// Lab07: To compare closed loop response of a given system using
// P, PI and PID controller.

//              scilab - 5.5.2
//              Operating System : Windows 7, 32-bit
//------------------------------------------------------------------------

//Clean the environment
xdel(winsid());//close all graphics Windows clear ;
clear;
clc;

//------------------------------------------------------------------------
//// Transfer function
s=%s; // or 
s=poly(0,'s');
sys=syslin('c',(1)/(s^2+10*s+20))

//step response 
t=0:0.05:2.5;
v=csim('step',t,sys);
plot2d(t,v,2)

//Title, labels and grid to the figure
//figure handel settings
f=get("current_figure"); //Current figure handle
f.background=8; //make the figure window background white
l=f.children(1); 
l.background=8 ;//make the text background white
id=color('grey');
xgrid(id);
//custom script for setting figure properties
title('Response of given system to a step','fontsize',3)
xlabel('Time t (sec.)','fontsize',2)
ylabel('Amplitude','fontsize',2)

//------------------------------------------------------------------------

// Response of the system with proportional controller
Kp=10;
sys_P=syslin('c',(Kp)/(s^2+10*s+20+Kp));

//step response 
figure;
t=0:0.05:2.5;
v=csim('step',t,sys_P);
plot2d(t,v,2)

//Title, labels and grid to the figure
//figure handel settings
f=get("current_figure"); //Current figure handle
f.background=8; //make the figure window background white
l=f.children(1); 
l.background=8 ;//make the text background white
id=color('grey');
xgrid(id);
title('Response of given system with Proportional controller','fontsize',3)
xlabel('Time t (sec.)','fontsize',2)
ylabel('Amplitude','fontsize',2)
xstring(1,0.31,"Steady state error=(1-0.335)*100=66.5%")

//------------------------------------------------------------------------
// Response of the system with proportional plus integral (PI) controller
Kp=25;
Ki=60;
sys_PI=syslin('c',(Kp*s+Ki)/(s^3+10*s^2+(20+Kp)*s+Ki));

//step response 
figure;
t=0:0.05:2.5;
v=csim('step',t,sys_PI);
plot2d(t,v,2)

//Title, labels and grid to the figure
//figure handel settings
f=get("current_figure"); //Current figure handle
f.background=8; //make the figure window background white
l=f.children(1); 
l.background=8 ;//make the text background white
id=color('grey');
xgrid(id);
title('Response of given system with Proportional plus integral...
 controller','fontsize',3)
xlabel('Time t (sec.)','fontsize',2)
ylabel('Amplitude','fontsize',2)
xstring(1,0.93,"Steady state error=(1-1)*100=0%")

//------------------------------------------------------------------------
// Response of the system with proportional plus integral plus 
//derivative (PID) controller
Kp=25;
Ki=60;
Kd=1;
sys_PID=syslin('c',(Kd*s^2+Kp*s+Ki)/(s^3+(10+Kd)*s^2+(20+Kp)*s+Ki));

//step response 
figure;
t=0:0.05:2.5;
v=csim('step',t,sys_PID);
plot2d(t,v,2)

//Title, labels and grid to the figure
//figure handel settings
f=get("current_figure"); //Current figure handle
f.background=8; //make the figure window background white
l=f.children(1); 
l.background=8 ;//make the text background white
id=color('grey');
xgrid(id);

title('Response of given system with Proportional plus integral...
 plus derivative controller','fontsize',3)
xlabel('Time t (sec.)','fontsize',2)
ylabel('Amplitude','fontsize',2)
xstring(1,0.93,"Settling time improved to 1.6 sec.")
//------------------------------------------------------------------------
